var DATA = {},
	DOMAIN = 'https://improver-192023.appspot.com/',
	SITE = 'https://www.improver.io/',
	LOADING = false;

function saveDATA(fn) {
	chrome.storage.local.set(DATA, function() {
		if (fn) {
			fn()
		}
	});
}

function load() {
	if (DATA.token) {
		var i = 0,
			sID = '';
		if (Object.keys(DATA.remind).length > 0) {
			for (var key in DATA.remind) {
				if (DATA.remind[key].status == 0) {
					sID += '{"userID": "' + key + '"},';
					i++;
				}
			}
		}
		if (i > 0) {
			var url = DOMAIN + 'status';
			sID = sID.slice(0, -1);
			var send = '{"token": "' + DATA.token + '","users": [' + sID + ']}';
		} else {
			var url = DOMAIN + 'credits'
			var send = '{"token": "' + DATA.token + '"}';
		}
		var xhr = new XMLHttpRequest();
		xhr.open('POST', url);
		xhr.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
		xhr.onload = function() {
			json = JSON.parse(xhr.response);
			console.log(xhr);
			if (json.status == 'ok') {
				if (typeof json.credits !== "undefined") {
					DATA.credits = parseInt(json.credits, 10) || 0;
				}
				if (typeof json.maxCredits !== "undefined") {
					DATA.maxCredits = parseInt(json.maxCredits, 10) || 0;
				}
				if (typeof json.users !== "undefined") {
					for (var key in json.users) {
						if (json.users[key] == true) {
							DATA.remind[key].status = 1;
						} else {
							console.log(key, json.users[key]);
						}
					}
				}
				saveDATA();
				updateIcon();
			} else if (json.error && json.error.message == "Wrong token") {
				DATA.token = "";
				saveDATA();
			}
		};
		xhr.onerror = function() {
			console.log(xhr);
		};
		xhr.send(send);
	}
	if (DATA.hasOwnProperty("mixID")) {
		mixpanel.identify(DATA.mixID);
	}
}
chrome.storage.local.get(function(result) {
	DATA = result;
	load();
})
chrome.storage.onChanged.addListener(function(e) {
	chrome.storage.local.get(function(result) {
		console.log(e);
		DATA = result;
	})
});
chrome.browserAction.setPopup({
	popup: "/popup.html"
})
chrome.browserAction.onClicked.addListener(function(tab) {
	if (tab.url.match(/\/in\//) || tab.url.match(/\/recruiter\/profile\//)) {
		chrome.tabs.sendMessage(tab.id, 'open');
	}
})

function XHR_LN(id, page) {
	return new Promise(function(resolve, reject) {
		var xhr = new XMLHttpRequest();
		xhr.open('GET', 'https://www.linkedin.com/voyager/api/identity/profiles/' + id + '/' + page);
		xhr.setRequestHeader("csrf-token", DATA.cookie);
		xhr.onload = function() {
			if (this.status == 200) {
				resolve(JSON.parse(xhr.response));
			} else {
				console.log(xhr)
				reject(xhr);
			}
		}
		xhr.onerror = function() {
			console.log(xhr);
			reject(xhr);
		};
		xhr.send();
	})
}

function XHR_IMPSERV(page, obj) {
	return new Promise(function(resolve, reject) {
		var xhr = new XMLHttpRequest();
		xhr.open('POST', DOMAIN + page);
		xhr.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
		xhr.onload = function() {
			if (this.status == 200) {
				resolve(JSON.parse(xhr.response));
			} else {
				console.log(xhr)
				reject(xhr);
			}
		};
		xhr.onerror = function() {
			console.log(xhr);
			reject(xhr);
		};
		xhr.send(JSON.stringify(obj))
	})
}

function getUserMore(url_id, profile, tabID) {
	text_ = '';
	if (profile.profile.hasOwnProperty('headline')) {
		text_ += profile.profile.headline + ' \n';
	}
	if (profile.profile.hasOwnProperty('summary')) {
		text_ += profile.profile.summary + ' \n';
	}
	if (profile.hasOwnProperty('educationView')) {
		profile.educationView.elements.forEach(function(item) {
			if (item.hasOwnProperty('degreeName')) {
				text_ += item.degreeName + ' \n';
			}
			if (item.hasOwnProperty('schoolName')) {
				text_ += item.schoolName + ' \n';
			}
		})
	}
	if (profile.hasOwnProperty('positionView')) {
		profile.positionView.elements.forEach(function(item) {
			if (item.hasOwnProperty('companyName')) {
				text_ += item.companyName + ' \n';
			}
			if (item.hasOwnProperty('title')) {
				text_ += item.title + ' \n';
			}
			if (item.hasOwnProperty('description')) {
				text_ += item.description + ' \n';
			}
		})
	}
	Promise.all([XHR_LN(url_id, 'skillCategory?includeHiddenEndorsers=true')]).then(function(v) {
		v[0].elements.forEach(function(item) {
			item.endorsedSkills.forEach(function(item2) {
				text_ += item2.skill.name + ' \n';
			})
		})
		XHR_IMPSERV('recognize', {
			"token": DATA.token,
			'text': text_
		}).then(function(r) {
			r.vacancies.sort((a, b) => b.rating - a.rating);
			chrome.tabs.sendMessage(tabID, {
				'glossary': r.vacancies
			});
		}).catch(function(reason) {
			console.log(reason)
		})
	}).catch(function(reason) {
		console.log(reason)
	});
}

function sendUserInfo(tabID, p, i) {
	chrome.tabs.sendMessage(tabID, {
		'userInfo': p
	}, function(request) {
		if (!request && i < 10) {
			setTimeout(function() {
				sendUserInfo(tabID, p, i++)
			}, 500);
		}
	});
}
chrome.tabs.onUpdated.addListener(function(tabID, info, tab) {
	if (info.status === 'complete' && tab.url.match('linkedin.com')) {
		if (tab.url.match(/\/in\//) || tab.url.match(/\/recruiter\/profile\//)) {
			updateIcon();
			send = 'show';
			chrome.browserAction.setPopup({
				tabId: tabID,
				popup: ""
			})
		} else {
			send = 'hide';
			chrome.browserAction.setPopup({
				tabId: tabID,
				popup: "/popup.html"
			})
		}
		chrome.tabs.sendMessage(tabID, send);
		LOADING = false;
	}
	if (LOADING === false && info.status === 'loading' && tab.url.match('linkedin.com')) {
		LOADING = true;
		if (tab.url.match(/\/in\//)) {
			if (DATA.token && DATA.cookie) {
				var url_id = decodeURI(new URL(tab.url).pathname.match(/([^\/]*)\/?$/)[1]);
				XHR_LN(url_id, 'profileView').then(function(p) {
					sendUserInfo(tabID, p, 0)
					if (DATA.glossary) {
						getUserMore(url_id, p, tabID);
					}
				});
			}
		}
	}
});
chrome.browserAction.setBadgeBackgroundColor({
	color: [78, 67, 194, 255]
});

function updateIcon() {
	var i = 0;
	if (Object.keys(DATA.remind).length > 0) {
		for (var key in DATA.remind) {
			if (DATA.remind[key].status == 1) {
				i++;
			}
		}
	}
	if (i > 0) {
		chrome.browserAction.setBadgeText({
			text: '' + i
		});
	} else {
		chrome.browserAction.setBadgeText({
			text: ''
		});
	}
}
chrome.runtime.onMessage.addListener(function(request, sender, sendResponse) {
	if (request.getuser) {
		userdata = request.getuser;
		var xhr = new XMLHttpRequest();
		xhr.open('POST', DOMAIN + 'user');
		xhr.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
		xhr.onload = function() {
			sendResponse(JSON.parse(xhr.response));
		};
		xhr.onerror = function() {
			sendResponse(json = {
				error: {
					code: "000",
					message: "Error connect"
				}
			});
			console.log(xhr);
		};
		xhr.send(JSON.stringify({
			"token": DATA.token,
			"userID": userdata.id,
			"userCode": userdata.url_id,
			"name": userdata.name,
			"source": userdata.source
		}))
		return true;
	} else if (request.sendStatus) {
		var xhr = new XMLHttpRequest();
		xhr.open('POST', DOMAIN + 'status');
		xhr.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
		xhr.onload = function() {};
		xhr.onerror = function() {
			console.log(xhr);
		};
		xhr.send(JSON.stringify({
			'status': request.sendStatus.status,
			"token": request.sendStatus.token,
			'users': [{
				"userID": request.sendStatus.id
			}]
		}));
		mixpanel.track(request.sendStatus.status, {
			"token1": request.sendStatus.token,
			"credits": request.sendStatus.credits,
			'id': request.sendStatus.id,
			'url': request.sendStatus.url_id,
			'name': request.sendStatus.name
		});
		return true;
	} else if (request.iwn) {
		var xhr = new XMLHttpRequest();
		xhr.open('POST', DOMAIN + 'iwnButton' + request.iwn);
		xhr.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
		xhr.onload = function() {
			sendResponse(JSON.parse(xhr.response));
		};
		xhr.onerror = function() {
			sendResponse(json = {
				error: {
					code: "000",
					message: "Error connect"
				}
			});
			console.log(xhr);
		};
		xhr.send('{"token": "' + DATA.token + '"}');
		mixpanel.track('Ready to pay!');
		return true;
	} else if (request.hasOwnProperty("token") || request.hasOwnProperty("mixID")) {
		DATA.token = request.token;
		if (request.hasOwnProperty("mixID") && !DATA.hasOwnProperty('mixID')) {
			DATA.mixID = request.mixID;
			mixpanel.identify(DATA.mixID);
		}
		saveDATA(load);
		return true;
	} else if (request.hasOwnProperty("glossary")) {
		getUserMore(request.glossary[0], request.glossary[1], sender.tab.id);
		return true;
	}
	if (request.mixpanel) {
		console.log(request.mixpanel)
		mixpanel.track(request.mixpanel.status, request.mixpanel.data);
		return true;
	}
	return false;
});
chrome.runtime.onInstalled.addListener(function(details) {
	if (details.reason == "install") {
		if (!DATA.hasOwnProperty('contacts')) {
			DATA.contacts = {};
		}
		if (!DATA.hasOwnProperty('remind')) {
			DATA.remind = {};
		}
		if (!DATA.hasOwnProperty('glossary')) {
			DATA.glossary = 0;
		}
		if (!DATA.hasOwnProperty('cookie')) {
			DATA.cookie = '';
		}
		saveDATA();
		chrome.tabs.create({
			url: SITE + 'account?install'
		});
		mixpanel.track('Install Extensions!');
	}
	if (details.reason == "update") {
		if (Number(details.previousVersion) <= 0.9) {
			for (var key in DATA.remind) {
				if (DATA.remind[key].hasOwnProperty("url")) {
					DATA.remind[key].url = DATA.remind[key].url.replace(/^\/in\//, '');
				}
			}
			for (var key in DATA.contacts) {
				if (DATA.contacts[key].hasOwnProperty("url")) {
					DATA.contacts[key].url = DATA.contacts[key].url.replace(/^\/in\//, '');
				}
			}
		}
		if (Number(details.previousVersion) <= 1) {
			if (!DATA.hasOwnProperty('glossary')) {
				DATA.glossary = 0;
			}
			if (!DATA.hasOwnProperty('cookie')) {
				DATA.cookie = '';
			}
			saveDATA();
			if (DATA.hasOwnProperty('name')) {
				chrome.storage.local.remove('name');
			}
		}
	}
})
setInterval(function() {
	load();
}, 1800000);
window.MIXPANEL_CUSTOM_LIB_URL = chrome.extension.getURL('js/mixpanel-2.20.0.min.js');
(function(e, a) {
	if (!a.__SV) {
		var b = window;
		try {
			var c, l, i, j = b.location,
				g = j.hash;
			c = function(a, b) {
				return (l = a.match(RegExp(b + "=([^&]*)"))) ? l[1] : null
			};
			g && c(g, "state") && (i = JSON.parse(decodeURIComponent(c(g, "state"))), "mpeditor" === i.action && (b.sessionStorage.setItem("_mpcehash", g), history.replaceState(i.desiredHash || "", e.title, j.pathname + j.search)))
		} catch (m) {}
		var k, h;
		window.mixpanel = a;
		a._i = [];
		a.init = function(b, c, f) {
			function e(b, a) {
				var c = a.split(".");
				2 == c.length && (b = b[c[0]], a = c[1]);
				b[a] = function() {
					b.push([a].concat(Array.prototype.slice.call(arguments, 0)))
				}
			}
			var d = a;
			"undefined" !== typeof f ? d = a[f] = [] : f = "mixpanel";
			d.people = d.people || [];
			d.toString = function(b) {
				var a = "mixpanel";
				"mixpanel" !== f && (a += "." + f);
				b || (a += " (stub)");
				return a
			};
			d.people.toString = function() {
				return d.toString(1) + ".people (stub)"
			};
			k = "disable time_event track track_pageview track_links track_forms register register_once alias unregister identify name_tag set_config reset people.set people.set_once people.unset people.increment people.append people.union people.track_charge people.clear_charges people.delete_user".split(" ");
			for (h = 0; h < k.length; h++) e(d, k[h]);
			a._i.push([b, c, f])
		};
		a.__SV = 1.2;
		b = e.createElement("script");
		b.type = "text/javascript";
		b.async = !0;
		b.src = "undefined" !== typeof MIXPANEL_CUSTOM_LIB_URL ? MIXPANEL_CUSTOM_LIB_URL : "file:" === e.location.protocol && "//cdn.mxpnl.com/libs/mixpanel-2-latest.min.js".match(/^\/\//) ? "https://cdn.mxpnl.com/libs/mixpanel-2-latest.min.js" : "//cdn.mxpnl.com/libs/mixpanel-2-latest.min.js";
		c = e.getElementsByTagName("script")[0];
		c.parentNode.insertBefore(b, c)
	}
})(document, window.mixpanel || []);
mixpanel.init("fd5a943fddad32c65c32fbf2379514f4");