function imagepath() {
	return (document.querySelector('.pv-top-card-section__image > div') && document.querySelector('.pv-top-card-section__image > div').style.backgroundImage.slice(4, -1).replace(/"/g, "")) || 'https://static.licdn-ei.com/scds/common/u/images/themes/katy/ghosts/person/ghost_person_200x200_v1.png';
}

function copyContect(ev) {
	text = this.parentNode.textContent.replace(/(\.|\@)<wbr>/g, "$1");
	const input = document.createElement('input');
	input.style.position = 'fixed';
	input.style.opacity = 0;
	input.value = text;
	document.body.appendChild(input);
	input.select();
	document.execCommand('Copy', false, null);
	document.body.removeChild(input);
	this.classList.add('imp_ok');
}

function imp_show() {
	if (Boolean(masterDiv.dataset.load) === true) {
		masterDiv.classList.toggle("imp_hide");
	} else {
		chrome.storage.local.get(function(result) {
			DATA = result;
			if (DATA.token) {
				parseId(function(parse) {
					if (DATA.contacts[parse.id]) {
						imp_open_contact(parse.id);
					} else if (DATA.remind[parse.id] && DATA.credits > 0) {
						showcontact.classList.add('imp_hide_');
						info.classList.remove('imp_hide_');
						info_btn.classList.remove('imp_hide_');
						info_btn.classList.add('delete');
						info_btn.textContent = chrome.i18n.getMessage('_info1_del');
						info_btn.addEventListener("click", remind);
					} else {
						showcontact.style.opacity = 1;
					}
					if (Object.keys(DATA.remind).length > 0) {
						for (var key in DATA.remind) {
							if (DATA.remind[key].status === 1 && DATA.remind[key].hide === 0 && key !== parse.id) {
								let this_key = key,
									this_contact = DATA.remind[this_key],
									ul = document.createElement('ul');
								ul.className = 'swlist single';
								ul.insertAdjacentHTML('afterbegin', '<li class="li_found_title">' + chrome.i18n.getMessage('_waitinglist_single') +
									'<span class="close"></span></li>' +
									'<li class="li_found"><img src="' + this_contact.img + '">' +
									'<p>' + this_contact.name + '</p>' +
									'<small>' + this_contact.specialty + '</small><span class="found">FOUND</span></li>');
								section.insertBefore(ul, section.firstChild);
								document.querySelector('#improver .close').addEventListener('click', function() {
									ul.className = 'imp_hide_';
									DATA.remind[this_key].hide = 1;
									saveDATA();
								});
								document.querySelector('#improver .li_found').addEventListener('click', function() {
									delete DATA.remind[this_key];
									saveDATA();
									window.location.href = '//www.linkedin.com/in/' + this_contact.url + '#showContact';
								});
								break;
							}
						};
					}
				});
				if (DATA.credits <= 0) {
					showcontact.classList.add('imp_hide_');
					info.classList.remove('imp_hide_');
					info.style.fontWeight = 'normal';
					iwn();
				}
				loginbtn.textContent = chrome.i18n.getMessage('_logout');
				loginbtn.href = SITE + 'logout';
				credits.classList.remove('imp_hide_');
				waitinglist.classList.remove('imp_hide_');
			} else {
				loginbtn.textContent = chrome.i18n.getMessage('_login');
				loginbtn.href = SITE + 'login';
				showcontact.classList.add('imp_hide_');
				info.classList.remove('imp_hide_');
				info.textContent = chrome.i18n.getMessage('_login_mes');
				profile.appendChild(loginbtn);
				footer.classList.add('imp_hide_');
				footer.setAttribute("style", "height:0;padding:0;");
				let waitToken = setInterval(function() {
					chrome.storage.local.get(function(result) {
						if (result.token) {
							clearInterval(waitToken);
							if (typeof masterDiv === "object") {
								masterDiv.remove();
							}
							if (typeof WLsection === "object") {
								WLsection.remove();
								WLsection = '';
							}
							template();
							imp_show();
						}
					})
				}, 500);
			}
			if (document.location.pathname.match(/^\/in[^\/]*/)) {
				avatar.src = imagepath();
				name_i.textContent = document.querySelector('h1.pv-top-card-section__name').textContent;
				specialty_i.textContent = document.querySelector('h2.pv-top-card-section__headline').textContent;
			}
			if (document.location.pathname.match(/^\/recruiter\/profile[^\/]*/)) {
				avatar.src = document.querySelector('#topcard.module.primary-module .module-body img').src;
				name_i.textContent = document.querySelector('#topcard.module.primary-module h1') && document.querySelector('#topcard.module.primary-module h1').textContent || "";
				specialty_i.textContent = document.querySelector('#topcard.module.primary-module li.title').textContent;
			}
			credits_span.textContent = (DATA.credits || 0) + '/' + (DATA.maxCredits || 0);
			masterDiv.dataset.load = true;
			masterDiv.classList.toggle("imp_hide");
			glossary();
		})
	}
}

function iwn() {
	if (DATA.iwn) {
		info.textContent = chrome.i18n.getMessage('_no_credits_2');
		info_btn.classList.add('imp_hide_');
	} else {
		info.textContent = chrome.i18n.getMessage('_no_credits_1');
		info_btn.textContent = chrome.i18n.getMessage('_no_credits');
		info_btn.addEventListener("click", function() {
			info_btn.classList.add('imp_hide_');
			chrome.runtime.sendMessage({
				iwn: 'Set'
			}, function(json) {
				if (json.error) {
					info.textContent = json.error.code + ": " + json.error.message;
				} else {
					DATA.iwn = true;
					saveDATA();
					info.textContent = chrome.i18n.getMessage('_no_credits_2');
				}
			})
		});
		info_btn.classList.remove('imp_hide_');
	}
}

function showWaitingList(e, one) {
	if (WLsection) {
		WLsection.remove();
		WLsection = '';
	}
	templateWaitingList();
	chrome.storage.local.get(function(result) {
		DATA = result;
		if (Object.keys(DATA.remind).length > 0) {
			var i = 0;
			for (var key in DATA.remind) {
				let this_key = key,
					this_contact = DATA.remind[this_key],
					li = document.createElement('li');
				li.insertAdjacentHTML('afterbegin', '<img src="' + this_contact.img + '">' +
					'<p>' + this_contact.name + '</p>' +
					'<small>' + this_contact.specialty + '</small>');
				let span = document.createElement('span');
				if (DATA.remind[this_key].status == 1) {
					li.addEventListener("click", function() {
						delete DATA.remind[this_key];
						saveDATA();
						window.location.href = '//www.linkedin.com/in/' + this_contact.url + '#showContact';
					});
					li.className = "ok";
					span.textContent = 'FOUND';
					span.className = 'found';
				} else {
					li.addEventListener("click", function() {
						window.location.href = '//www.linkedin.com/in/' + this_contact.url;
					});
					span.className = 'trash';
					span.dataset.title = chrome.i18n.getMessage('_waitinglist_del');
					span.addEventListener("click", function() {
						delete DATA.remind[this_key];
						saveDATA();
						li.style.opacity = 0;
						li.style.height = 0;
						li.style.minHeight = 0;
						setTimeout(function() {
							li.style.display = 'none'
						}, 200)
						event.stopPropagation();
					});
				}
				li.appendChild(span);
				WLul.appendChild(li);
				i++;
			}
			if (i > 4) {
				var refreshIntervalId = setInterval(function() {
					if (section.offsetHeight > 0 && document.querySelector('.swlist li').offsetHeight > 0) {
						var h = 9;
						list = document.querySelectorAll('.swlist li');
						for (var a = 0; a < 4; ++a) {
							h += list[a].offsetHeight;
						}
						if (section.offsetHeight > h) {
							WLsection.style.maxHeight = section.offsetHeight + 'px';
						} else if (h == 9) {
							WLsection.style.maxHeight = '332px';
						} else {
							WLsection.style.maxHeight = h + 9 + 'px';
						}
						clearInterval(refreshIntervalId);
					}
				}, 500);
			}
		}
		setTimeout(function() {
			if (one) {
				section.classList.add('hideSlide');
				waitinglist.textContent = chrome.i18n.getMessage('_waitinglist_back');
				waitinglist.classList.add('back');
			} else {
				if (section.classList.toggle('hideSlide')) {
					waitinglist.textContent = chrome.i18n.getMessage('_waitinglist_back');
					waitinglist.classList.add('back');
				} else {
					waitinglist.textContent = chrome.i18n.getMessage('_waitinglist') + ' (' + Object.keys(DATA.remind).length + ')';
					waitinglist.classList.remove('back');
				}
			}
		}, 100)
	});
}

function getUser(id, url_id, name, source) {
	user = {
		getuser: {
			'id': id,
			'url_id': url_id,
			'name': name,
			'source': source || ""
		}
	};
	chrome.runtime.sendMessage(user, function(json) {
		if (json.error) {
			showcontact.classList.add('imp_hide_');
			info.classList.remove('imp_hide_');
			if (json.error.code == '401') {
				iwn();
				DATA.credits = 0;
				saveDATA();
			} else {
				info.textContent = json.error.code + ": " + json.error.message;
			}
			if (json.error.message == "Wrong token") {
				DATA.token = "";
				saveDATA();
				reload('open');
			}
		} else {
			if (json.contacts) {
				chrome.runtime.sendMessage({
					mixpanel: {
						status: 'success get person',
						data: {
							"token1": DATA.token,
							"credits": DATA.credits,
							'id': id,
							'url': url_id,
							'name': name
						}
					}
				});
				DATA.contacts[id] = {};
				DATA.contacts[id].name = name;
				DATA.contacts[id].url = url_id;
				DATA.contacts[id].contacts = json.contacts;
				DATA.credits = json.credits;
				credits_span.textContent = (DATA.credits || 0) + '/' + (DATA.maxCredits || 0);
				saveDATA();
				imp_open_contact(id);
			} else {
				chrome.runtime.sendMessage({
					mixpanel: {
						status: 'person not found',
						data: {
							"token1": DATA.token,
							"credits": DATA.credits,
							'id': id,
							'url': url_id,
							'name': name
						}
					}
				});
				showcontact.classList.add('imp_hide_');
				info.classList.remove('imp_hide_');
				if (document.location.pathname.match(/^\/in[^\/]*/)) {
					info_btn.classList.remove('imp_hide_');
					info_btn.addEventListener("click", remind);
					if (DATA.remind[id]) {
						info_btn.classList.add('delete');
						info_btn.textContent = chrome.i18n.getMessage('_info1_del');
					}
				}
			}
		}
	});
}

function imp_open_contact(id) {
	contacts = DATA.contacts[id].contacts;
	for (var key in contacts) {
		let li = document.createElement('li');
		li.className = key;
		li.innerHTML = contacts[key].replace(/(\.|@)/g, "$1<wbr>");
		contactlist.appendChild(li);
		let span = document.createElement('span');
		span.className = 'imp_copy';
		span.addEventListener("click", copyContect);
		li.insertBefore(span, li.firstChild);
	}
	showcontact.classList.add('imp_hide_');
	contactlist.classList.remove('imp_hide_');
}

function parseId(callback) {
	if (document.location.pathname.match(/^\/in[^\/]*/)) {
		callback({
			'url': URL_ID,
			'id': PROFILE[URL_ID].profile.miniProfile.objectUrn.match(/[0-9]+/)[0],
			'name': PROFILE[URL_ID].profile.firstName + ' ' + PROFILE[URL_ID].profile.lastName,
			'specialty': PROFILE[URL_ID].headline || PROFILE[URL_ID].profile.miniProfile.occupation,
			'img': imagepath(),
			'source': PROFILE[URL_ID].profile
		})
	}
	if (document.location.pathname.match(/^\/recruiter\/profile[^\/]*/)) {
		if (document.querySelector('#topcard.module.primary-module .public-profile a')) {
			var url = new URL(document.querySelector('#topcard.module.primary-module .public-profile a').href).pathname.replace(/^\/in\//, '')
		} else {
			var url = document.location.pathname
		}
		callback({
			'url': url,
			'id': document.querySelector('#context-data-form input[name="profile-id"]').value,
			'name': document.querySelector('#topcard.module.primary-module h1') && document.querySelector('#topcard.module.primary-module h1').textContent || "",
			'specialty': document.querySelector('#topcard.module.primary-module li.title').textContent,
			'img': document.querySelector('#topcard.module.primary-module .module-body img').src
		})
	}
}

function imp_show_contact() {
	showcontact.removeEventListener("click", imp_show_contact);
	showcontact.textContent = chrome.i18n.getMessage('_showcontact_loading');
	chrome.storage.local.get(function(result) {
		DATA = result;
		parseId(function(parse) {
			if (DATA.contacts[parse.id]) {
				imp_open_contact(parse.id);
			} else {
				thiscontact = getUser(parse.id, parse.url, parse.name, parse.source);
			}
			if (DATA.hasOwnProperty('revealmixpanel')) {
				DATA.revealmixpanel = DATA.revealmixpanel + 1;
			} else {
				DATA.revealmixpanel = 1;
			}
			saveDATA();
			if (DATA.revealmixpanel == 1 || DATA.revealmixpanel == 10) {
				chrome.runtime.sendMessage({
					mixpanel: {
						status: 'Reveal contact (' + DATA.revealmixpanel + ')',
						data: {
							"token1": DATA.token,
							"credits": DATA.credits,
							'id': parse.id,
							'url': parse.url,
							'name': parse.name
						}
					}
				});
			}
		});
	})
}

function remind() {
	_this = this;
	chrome.storage.local.get(function(result) {
		DATA = result;
		parseId(function(parse) {
			if (_this.classList.contains('delete')) {
				delete DATA.remind[parse.id];
				_this.classList.remove('delete');
				_this.textContent = chrome.i18n.getMessage('_info1');
				var curstatus = 'delete waiting'
			} else {
				DATA.remind[parse.id] = {
					'name': parse.name,
					'specialty': parse.specialty,
					'url': parse.url,
					'img': parse.img,
					'status': 0,
					'hide': 0
				};
				_this.classList.add('delete');
				_this.textContent = chrome.i18n.getMessage('_info1_del');
				var curstatus = 'added to waiting'
			}
			if (typeof WLsection === "object") {
				WLsection.remove();
				WLsection = '';
			}
			waitinglist.textContent = chrome.i18n.getMessage('_waitinglist') + ' (' + Object.keys(DATA.remind).length + ')';
			newcontact.dataset.coll = '+' + Object.values(DATA.remind).filter(v => v.status).length;
			saveDATA();
			chrome.runtime.sendMessage({
				sendStatus: {
					'status': curstatus,
					"token": DATA.token,
					"credits": DATA.credits,
					'id': parse.id,
					'url_id': parse.url,
					'name': parse.name,
				}
			});
		});
	})
}

function saveDATA() {
	console.log(DATA);
	chrome.storage.local.set(DATA);
}

function reload(r) {
	URL_ID = decodeURI(document.location.pathname.match(/([^\/]*)\/?$/)[1]) || null;
	if (typeof masterDiv === "object") {
		masterDiv.remove();
	}
	if (typeof WLsection === "object") {
		WLsection.remove();
		WLsection = '';
	}
	if (r == 'show' || r == 'open') {
		if (DATA.glossary) {
			sendUserPage();
		}
		template();
		newcontact.dataset.coll = '+' + Object.values(DATA.remind).filter(v => v.status).length;
		if (r == 'open') {
			imp_show();
		} else if (document.location.hash == '#showContact') {
			imp_show();
			imp_show_contact();
		}
	}
	var cookie = document.cookie.replace(/(?:(?:^|.*;\s*)JSESSIONID\s*\=\s*([^;]*).*$)|^.*$/, "$1").replace(/"/g, "");;
	if (DATA.cookie !== cookie) {
		DATA.cookie = cookie;
		saveDATA();
	}
}
var observer, OBSEconfig = {
		childList: true,
		subtree: true
	},
	OBSEdiv = document.querySelector('.core-rail')

function sendUserPage() {
	if (VACANCIES.hasOwnProperty(URL_ID)) {
		if (OBSEdiv) {
			obse(OBSEdiv);
		}
		highlight();
	} else {
		setTimeout(sendUserPage, 500);
	}
};

function obse(target) {
	if (observer) {
		observer.disconnect();
	}
	observer = new MutationObserver(function(mutations) {
		console.log(mutations[0])
		if (mutations[0].target.classList.contains('pv-top-card-section__summary-text')) {
			highlight(mutations[0].target);
		}
		if (mutations[0].target.classList.contains('pv-oc')) {
			highlight(mutations[0].target);
		}
		if (mutations[0].target.classList.contains('pv-deferred-area')) {
			highlight(mutations[0].target);
		}
		if (mutations[0].target.classList.contains('pv-profile-section')) {
			highlight(mutations[0].target);
		}
	});
	observer.observe(target, OBSEconfig);
}

function glossary() {
	glossarybtn.addEventListener('click', function() {
		if (!DATA.token) {
			window.open(SITE + 'login', '_blank').focus();
		} else if (DATA.glossary) {
			DATA.glossary = 0;
			glossarybtn.classList.remove('on');
			glossarytext.classList.remove('imp_hide_');
			addnewvacancy.classList.add('imp_hide_');
			glossaryUL.dataset.p = '';
			glossaryUL.textContent = '';
			highlightRenove();
		} else {
			DATA.glossary = 1;
			glossarybtn.classList.add('on')
			glossarytext.classList.add('imp_hide_');
			if (VACANCIES.hasOwnProperty(URL_ID)) {
				glossaryShow();
				highlight();
			} else {
				chrome.runtime.sendMessage({
					'glossary': [URL_ID, PROFILE[URL_ID]]
				});
				glossaryShow();
			}
		}
		saveDATA();
	})
	if (!DATA.token || !DATA.glossary) {
		glossarybtn.classList.remove('on');
		glossarytext.classList.remove('imp_hide_');
		addnewvacancy.classList.add('imp_hide_');
	} else {
		glossarybtn.classList.add('on');
		glossarytext.classList.add('imp_hide_');
		glossaryShow()
	}
	if (VACANCIES && VACANCIES.length <= 0) {
		glossarytext2.classList.remove('imp_hide_');
	}
	glossaryUL.addEventListener('click', function(e) {
		if (e.target.closest('li')) {
			glossaryUL.querySelectorAll('li.select').forEach(function(item) {
				item.classList.remove('select');
			})
			e.target.closest('li').classList.add('select');
			HIGHLIGH_SELECT = e.target.closest('li').dataset.id;
			highlight();
			e.stopPropagation();
			return false;
		}
	})
}

function glossaryShow() {
	if (!VACANCIES.hasOwnProperty(URL_ID)) {
		sendUserPage();
		let wait = setInterval(function() {
			if (VACANCIES) {
				glossaryShow();
				clearInterval(wait);
			}
		}, 500);
		return false;
	}
	if (VACANCIES[URL_ID].length < 5) {
		addnewvacancy.classList.remove('imp_hide_');
	}
	if (glossaryUL.dataset.p && glossaryUL.dataset.p == URL_ID) {
		return false;
	} else {
		var list = '';
		VACANCIES[URL_ID].forEach(function(item, i) {
			let more = 0,
				more2 = 4,
				symbols = 0;
			if (i == 0) {
				list += "<li class='select' data-id='" + i + "'>";
			} else {
				list += "<li data-id='" + i + "'>";
			}
			list += "<h3>" + item.name + "</h3><small style='background-color:" +
				COLOR[VACANCIES[URL_ID][i].rating][1][1] +
				"'>" + COLOR[item.rating][0] + "</small></li>";
		})
		glossaryUL.insertAdjacentHTML('afterbegin', list);
		glossaryUL.dataset.p = URL_ID;
		if (VACANCIES[URL_ID].length >= 5) {
			addnewvacancy.classList.add('imp_hide_');
		}
	}
}
var range = document.createRange();
var OBSEHACK = 0;

function highlight(elems) {
	if (!VACANCIES.hasOwnProperty(URL_ID)) {
		sendUserPage();
		return false;
	}
	OBSEHACK++;
	if (OBSEHACK > 100) {
		console.log('Запущен OBSE HACK');
		observer.disconnect();
		setTimeout(function() {
			observer.observe(OBSEdiv, OBSEconfig);
			OBSEHACK = 0;
		}, 3000)
		return false;
	}
	observer.disconnect();

	function HL(node, text, color_) {
		var skip = 0;
		if (node.nodeType == 3) {
			var regexp = new RegExp('(?:[^a-zа-я]|^)(' + text + ')(?:[^a-zа-я]|$)', 'gi');
			var pos = regexp.exec(node.textContent);
			if (pos) {
				var start = pos.index + pos[0].indexOf(pos[1]);
				if (start >= 0) {
					var spannode = document.createElement('font');
					spannode.className = 'imp_HL';
					spannode.style.backgroundColor = color_;
					var middlebit = node.splitText(start);
					var endbit = middlebit.splitText(pos[1].length);
					var middleclone = middlebit.cloneNode(true);
					spannode.appendChild(middleclone);
					middlebit.parentNode.replaceChild(spannode, middlebit);
					skip = 1;
				}
			}
		} else if (node.nodeType == 1 && node.childNodes && !/(script|style)/i.test(node.tagName)) {
			for (var i = 0; i < node.childNodes.length; ++i) {
				i += HL(node.childNodes[i], text, color_);
			}
		}
		return skip;
	};

	function HL4(text, color_) {
		return new Promise(function(resolve, reject) {
			if (!text.trim()) {
				resolve('no search tags');
				return false;
			}
			var regexp = new RegExp('(?:[^a-zа-я]|^)(' + text + ')(?:[^a-zа-я]|$)', 'gi');
			if (elems) {
				console.log('single')
				resolve(HL(elems, text, color_));
			} else {
				console.log('all')
				var elemsAll = '.pv-top-card-section__headline,' + '.pv-top-card-section__summary-text,' + '.pv-entity__summary-info,' + '.pv-entity__extra-details,' + '.pv-skill-categories-section__top-skills,' + '.pv-skill-category-list__skills_list,' + '.pv-profile-section__section-info section-info';
				document.querySelectorAll(elemsAll).forEach(function(el) {
					resolve(HL(el, text, color_));
				})
			}
		})
	}
	var tags = VACANCIES[URL_ID][HIGHLIGH_SELECT].tags
	var tags1 = [];
	var tags2 = [];
	for (var t in tags) {
		if (tags[t] == 1) tags1.push(t);
		if (tags[t] == 2) tags2.push(t);
	}
	var text1 = tags1.join('|').replace(/(\+|\?|\.|\*|\^|\\)/g, '\\$1');
	var text2 = tags2.join('|').replace(/(\+|\?|\.|\*|\^|\\)/g, '\\$1');
	highlightRenove(elems);
	Promise.all([HL4(text1, COLOR[VACANCIES[URL_ID][HIGHLIGH_SELECT].rating][1][1]), HL4(text2, COLOR[VACANCIES[URL_ID][HIGHLIGH_SELECT].rating][1][2])]).then(function() {
		observer.observe(OBSEdiv, OBSEconfig);
	}).catch(function(reason) {
		console.log(reason)
	});
}

function highlightRenove(elem) {
	elem = elem || document;
	elem.querySelectorAll('.imp_HL').forEach(function(el) {
		console.log('удалено')
		el.insertAdjacentHTML('afterend', el.textContent)
		el.remove();
	})
}