var DATA = {},
	SITE = 'https://improver.io/';

function saveDATA() {
	chrome.storage.local.set(DATA);
}
chrome.storage.local.get(function(result) {
	if (result) {
		DATA = result;
		header = document.querySelector('h1');
		loginbtn = document.querySelector('.loginbtn');
		if (DATA.token) {
			WLul = document.querySelector('ul');
			credits = document.querySelector('.imp_credits');
			credits.insertAdjacentHTML('afterbegin', chrome.i18n.getMessage('_credits') + '<span>' + (DATA.credits || 0) + '/' + (DATA.maxCredits || 0) + '</span>');
			var i = 0;
			if (Object.keys(DATA.remind).length > 0) {
				for (var key in DATA.remind) {
					let this_key = key,
						this_contact = DATA.remind[this_key],
						li = document.createElement('li');
					li.insertAdjacentHTML('afterbegin', '<img src="' + this_contact.img + '">' +
						'<p>' + this_contact.name + '</p>' +
						'<small>' + this_contact.specialty + '</small>');
					let span = document.createElement('span');
					if (DATA.remind[this_key].status == 1) {
						li.addEventListener("click", function() {
							delete DATA.remind[this_key];
							saveDATA();
							chrome.tabs.create({
								'url': 'https://www.linkedin.com/in/' + this_contact.url + '/#showContact'
							})
						});
						li.className = "ok";
						span.textContent = 'FOUND';
						span.className = 'found';
					} else {
						li.addEventListener("click", function() {
							chrome.tabs.create({
								'url': 'https://www.linkedin.com/in/' + this_contact.url
							})
						});
						span.className = 'trash';
						span.addEventListener("click", function() {
							delete DATA.remind[this_key];
							saveDATA();
							li.style.opacity = 0;
							li.style.height = 0;
							li.style.minHeight = 0;
							setTimeout(function() {
								li.style.display = 'none'
							}, 200)
							event.stopPropagation();
						});
					}
					li.appendChild(span);
					WLul.appendChild(li);
					i++;
				}
			}
			if (i == 0) {
				header.textContent = chrome.i18n.getMessage('popop_h1_no');
				document.querySelector('section').className = 'unicorn';
			} else {
				header.textContent = chrome.i18n.getMessage('_waitinglist') + ' (' + Object.keys(DATA.remind).length + ')';
				var h = 0;
				list = document.querySelectorAll('.swlist li');
				var lh = document.querySelectorAll('.swlist li').length;
				if (lh >= 4) {
					lh = 4
				};
				for (var a = 0; a < lh; ++a) {
					h += list[a].offsetHeight;
				}
				document.querySelector('.swlist').style.maxHeight = h + 39 + document.querySelector('.swlist h1').offsetHeight + 'px';
			}
			loginbtn.textContent = chrome.i18n.getMessage('_logout');
			loginbtn.href = SITE + 'logout.php';
		} else {
			header.textContent = chrome.i18n.getMessage('popop_h1_no');
			document.querySelector('section').className = 'unicorn';
			loginbtn.textContent = chrome.i18n.getMessage('_login');
			loginbtn.href = SITE + 'login.php';
		}
	}
})